# Supplementary Material - Model Predictive Adversarial Imitation Learning for Planning from Observation

## Code

The source in `mpail (code)/` has been modified slightly for anonymous review. If there are any issues, please let us know.

### Included
- Model training code (`mpail/learner.py`)
- MPPI implementation (`mpail/mppi/`) with optional mapping (`mpail/mppi/maps`)
- Runner code (`mpail/runner.py`)
- Deployment example (`test/load_mpail_policy.py`)

It is actually possible to start a training run with this source provided the necessary configurations are properly defined (provided the environment and dynamics). `mpail` is implemented to be a standalone package for the algorithm itself and indeed is used this way in the full source. Dependencies are also minimized such that the package is suitable for deployment on end-devices (e.g. NVIDIA Jetson devices). However, as we will eventually release integration infrastructure, we advise reading through this source for understanding the implementation.

Any configuration definitions in this source are not used but left as defaults for the package upon release. The actual configurations remain consistent with what is presented in the paper and is defined task-side (not included) as done in Isaac Lab.

### Released Upon Acceptance / De-anonymization
- Exact simulation environment and configurations
- GAIL and AIRL implementation for Isaac Lab
  - Note that we closely followed the implementation found in this [popular repository](https://github.com/HumanCompatibleAI/imitation) but adapted the code such that it did not rely on stable-baselines3 as it under-utilizes Isaac Lab simulation capabilities as shown [here](https://isaac-sim.github.io/IsaacLab/main/source/overview/reinforcement-learning/rl_frameworks.html).

## Other Supplementary Materials

Please also view other related materials included in the supplementary materials:

- Videos of GAIL in simulation and real in `Real GAIL/`
  - Training videos are included to show GAIL's failure to converge even in simulation (`Real GAIL/gail-iter<n>.mp4`) where `n` indicates the training iteration. These iterations were best performing.
  - Real test found at `Real GAIL/gail-real-test.mp4`

- Videos of MPAIL in real with cost visualization found at `mpail-with-visualization-<i>.mp4`. Note that these videos are real-time (1x speed) with 20 Hz visualization. These videos also highlight the planner's recovery behavior when the robot finds itself off-track.
